<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/user_input_handler_registry.php';

class MyPlugIN_EntryHandler
    implements UserInputHandler
{
    private $session;
    private $tv;

    public function __construct($session,$tv)
    {
        $this->session = $session;
	$this->tv = $tv;

        UserInputHandlerRegistry::get_instance()->
            register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_handler_id()
    {
        return 'entry';
    }

	public function info_file()
    {
		if (file_exists(DuneSystem::$properties['install_dir_path'] . '/information.txt'))
		{
			$msg = file_get_contents(DuneSystem::$properties['install_dir_path'] . '/information.txt');
			#hd_print("msg------------------------->$msg");
			$defs = array();
			ControlFactory::add_multiline_label($defs,'' ,$msg,9);
			ControlFactory::add_label($defs, ' ', '');
			$this->add_close_dialog_and_apply_button($defs,
            'test', 'Я прочитал(а)', 270);
			$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
			$attrs['actions'] = null;
			return  ActionFactory::show_dialog_glass("Что нового в этой версии", $defs, false, 1400, $attrs);
		}
		else
		{
			return ActionFactory::open_folder();
		}
    }
	public function rename()
    {
		$old = DuneSystem::$properties['install_dir_path'] . '/information.txt';
		$new = DuneSystem::$properties['install_dir_path'] . '/information.old';
		rename($old, $new); 
        return;
    }
    public function handle_user_input(&$user_input, &$plugin_cookies)
    {

        hd_print('Entry handler: handle_user_input:');
        foreach ($user_input as $key => $value)
            hd_print("  $key => $value");
		$this->session->check_login($plugin_cookies);
		
		$control_id = isset($user_input->control_id) ?
            $user_input->control_id : '';
		#hd_print("control_id--------->$control_id");
        $open_folder_action = ActionFactory::open_folder();
		if ($control_id == 'test')
		{
			hd_print("RENAME");
		$this->rename();
		return ActionFactory::open_folder();
		}
        if (!isset($user_input->entry_id))
            return null;

        $add_params = array(
            'entry_id' => $user_input->entry_id);
        
        if ($user_input->entry_id === 'tv')
        {
		#hd_print("tv1------------------------->");
		
		$check = $this->info_file();
            $res = $this->session->apply_sub(
                $plugin_cookies, $user_input);
            if ($res !== false)
            {
			#hd_print("is nottttttttttttttttttttt");
				if (!isset($res['action']))
                {
                    return ActionFactory::close_dialog_and_run(
                        $open_folder_action);
                }

                return $res['need_close_dialog'] ?
                    ActionFactory::close_dialog_and_run($res['action']) :
                    $res['action'];
            }
            else
            {
			#hd_print("ssssssssssssssssss");
			
        if ($this->session->is_logged_in() == 1)
		{
		#hd_print("login = 1");
			if($user_input->entry_id !== 'setup')
					{
						$check = $this->info_file();
						if($check !== false)
							return $check;
					}
            #return $open_folder_action;
		}
		if(!isset($plugin_cookies->is_login_correct))
		{
		#hd_print("begine mit autor.....");
		$plugin_cookies->is_login_correct = 0;
		}

        if ($this->session->is_logged_in() === false && $plugin_cookies->is_login_correct == 1)
		{
			hd_print("unloаd channеls<");
			$this->tv->unload_channels();
		}
                if (!isset($plugin_cookies->is_login_correct) ||
                    $plugin_cookies->is_login_correct == 0)
                {
					try
					{
						$this->session->login_mylogin($plugin_cookies);
					}
					catch (Exception $e)
					{
						return $this->session->do_get_edit_subscription_action(
							$plugin_cookies, $this, $add_params);
					}
                }

                return $open_folder_action;
            }
        }
	else 
	{
		
		return ActionFactory::open_folder();
	}
	
		
        return null;
    }
	protected function add_close_dialog_and_apply_button(&$defs,
        $name, $caption, $width)
    {
        $params = array('button_caption_centered' => 1);
        ControlFactory::add_close_dialog_and_apply_button($defs,
            $this, null,
            $name, $caption, $width, $params);
    }
}

///////////////////////////////////////////////////////////////////////////
?>
