<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/abstract_controls_screen.php';

///////////////////////////////////////////////////////////////////////////

class MyPlugIN_SetupScreen extends AbstractControlsScreen
{
    const ID = 'setup';
	const EPG_FONTSIZE_DEF_VALUE	= 'normal';
	private	$epg_font_size;
	private $page_num = 1;
    private $session;
    private $account;
    ///////////////////////////////////////////////////////////////////////
   public static function get_media_url_str()
    {
        return MediaURL::encode(
            array
            (
                'screen_id' => self::ID,
            ));
    }
    public function __construct($session,$tv)
    {
        parent::__construct(self::ID);

        $this->session = $session;
        $this->tv = $tv;
    }
	///////////////////////////record///////////////////////////////////////////
	public function do_get_ip_path_smb_defs(&$plugin_cookies)
    {
        $smb_user = isset($plugin_cookies->smb_user) ? 
		$plugin_cookies->smb_user : 'guest';
		$smb_pass = isset($plugin_cookies->smb_pass) ? 
		$plugin_cookies->smb_pass : 'guest';
		$ip_path = isset($plugin_cookies->ip_path) ? 
		$plugin_cookies->ip_path : '';
		$defs = array();
		
		$this->add_text_field($defs,
                    'ip_path',
                   'Путь к SMB папке(IP/имя папки/..)',
                    $ip_path, 0, 0, 0, 1, 750, 0, 0
            );
        $this->add_text_field($defs,
                    'smb_user',
                    'Имя пользователя SMB папки:',
                    $smb_user, 0, 0, 0, 1, 750, 0, 0
            );

		$this->add_text_field($defs,
                    'smb_pass',
                    'Пароль SMB папки:',
                    $smb_pass, 0, 1, 0, 1, 750, 0, 0
            );
        
        $this->add_close_dialog_and_apply_button($defs,
            'ip_path_smb_apply', 'ОК', 250);
        $this->add_close_dialog_button($defs,
            'Отмена', 250);
 
        return $defs;
    }
	public function do_get_recdata_path_smb_defs(&$plugin_cookies)
    {
        $recdata_smb_user = isset($plugin_cookies->recdata_smb_user) ? 
		$plugin_cookies->recdata_smb_user : 'guest';
		$recdata_smb_pass = isset($plugin_cookies->recdata_smb_pass) ? 
		$plugin_cookies->recdata_smb_pass : 'guest';
		$recdata_ip_path = isset($plugin_cookies->recdata_ip_path) ? 
		$plugin_cookies->recdata_ip_path : '';
		$defs = array();
		
		$this->add_text_field($defs,
                    'recdata_ip_path',
                   'Путь к SMB папке(IP/имя папки/..)',
                    $recdata_ip_path, 0, 0, 0, 1, 750, 0, 0
            );
        $this->add_text_field($defs,
                    'recdata_smb_user',
                    'Имя пользователя SMB папки:',
                    $recdata_smb_user, 0, 0, 0, 1, 750, 0, 0
            );

		$this->add_text_field($defs,
                    'recdata_smb_pass',
                    'Пароль SMB папки:',
                    $recdata_smb_pass, 0, 1, 0, 1, 750, 0, 0
            );
        
        $this->add_close_dialog_and_apply_button($defs,
            'recdata_path_smb_apply', 'ОК', 250);
        $this->add_close_dialog_button($defs,
            'Отмена', 250);
 
        return $defs;
    }
    public function do_get_control_defs(&$plugin_cookies)
    {
       $defs = array();
	   $pass_sex = (isset($plugin_cookies->pass_sex) ? $plugin_cookies->pass_sex : '0000');
	   $epg_font_size = isset($plugin_cookies->epg_font_size) ? $plugin_cookies->epg_font_size : self::EPG_FONTSIZE_DEF_VALUE;
       $show_tv = isset($plugin_cookies->show_tv) ?
            $plugin_cookies->show_tv : 'yes';
        $show_vod = isset($plugin_cookies->show_vod) ?
            $plugin_cookies->show_vod : 'yes';
		$islogged = $this->session->is_logged_in();
		#hd_print("is_logged->>>>: $islogged");
		$is_login_correct = isset($plugin_cookies->is_login_correct) ? $plugin_cookies->is_login_correct : false;
		#hd_print("is_login_correct:$is_login_correct");
		$paket = $this->session->get_akk_pro();
		#hd_print("paket-------->" . json_encode($paket));
		$settings = $this->session->get_settings_pro();
		#hd_print("settings-------->" . json_encode($settings));
		if ($paket !== 0)
		{
			$akk = $paket->account->info->login;
		}
		#	$this->add_label($defs,'tvclub Plugin:', 'Версия: 1.0.0');
		$acc_time_shift = isset($plugin_cookies->time_shift) ? strval($acc_settings->time_shift) : 0;
		////////////////////////record////////////////////////////////////////////
		$recdata = isset($plugin_cookies->recdata) ? 
		$plugin_cookies->recdata : '/D';
		$recdata_dir = isset($plugin_cookies->recdata_dir) ? 
		$plugin_cookies->recdata_dir : '/';
		////////////////////////////////////////////////////////////////////////	
		$plugin_dir = DuneSystem::$properties['install_dir_path'];
        $xml = simplexml_load_file($plugin_dir . '/dune_plugin.xml');
		$this->add_label($defs,'Плагин tvclub.us:', 'Версия плагина: ' . VERSION_MAJOR . '.' . VERSION_MINOR . '.' . VERSION_SUBMINOR . ' [' . VERSION_DATE . ']');
		////////////////////////////
		if ($this->page_num == 1)
		{
		
		//////////////////////////
		$this->add_button
        (
            $defs,
            'abonement',
            "Абонемент для $akk:",
            'Подробнее',
            700
        );
		$this->add_button($defs, 'edit_subscription', null,
            'Изменить пользователя', 0);	
		################################################################
		$stream_server_ops = array();
		$stream_server = intval($settings->settings->current->server->id);
		#hd_print("stream_server--->$stream_server");
		foreach ($settings->settings->lists->servers as $pair)
			$stream_server_ops[intval($pair->id)] = strval($pair->name) . ' (загружен на ' . strval($pair->load) . '% из ' . strval($pair->power) . ')';
		$this->add_combobox($defs,
			'stream_server', 'Сервер вещания:',
			$stream_server, $stream_server_ops, 700, true);
		###################################################################
		$timezone_ops = array();
		$timezone = $settings->settings->current->timezone->id;
		#hd_print("timezone--->$timezone");
		foreach ($settings->settings->lists->timezones as $pair)
			$timezone_ops[$pair->id] = strval($pair->gmt). ' (' .strval($pair->id). ')';
		$this->add_combobox($defs,
			'timezone', 'Временная зона:',
			$timezone, $timezone_ops, 700, true);
		###################################################################	
			$buf_time = isset($plugin_cookies->buf_time) ? $plugin_cookies->buf_time : 0;
			#hd_print("buff:$buf_time");
			$show_buf_time_ops = array();
			$show_buf_time_ops['0'] = 'По умолчанию';
			$show_buf_time_ops['500'] = '0.5 сек';
			$show_buf_time_ops['1000'] = '1 сек';
			$show_buf_time_ops['1500'] = '1.5 сек';
			$show_buf_time_ops['2000'] = '2.0 сек';
			$show_buf_time_ops['2500'] = '2.5 сек';
			$show_buf_time_ops['3000'] = '3 сек';
			$show_buf_time_ops['5000'] = '5 сек';
			$show_buf_time_ops['8000'] = '8 с';
			$show_buf_time_ops['10000']	= '10 сек';
			$show_buf_time_ops['15000'] = '15 с';
			$this->add_combobox
        		(
            			$defs,
            			'http_caching',
            			'Время буферизации:',
            			$buf_time, $show_buf_time_ops, 700, true
        		);
			
			$this->add_button($defs, 'edit_pcode','Код закрытых каналов:',
                'Изменить...', 0);
        		
			//////////////////////////epg font//////////////////////////////////////
			$epg_font_size_ops = array();
			$epg_font_size_ops ['normal'] = 'Обычный';
			$epg_font_size_ops ['small'] = 'Мелкий';
			$this->add_combobox($defs,
				'epg_font_size', 'Размер шрифта EPG:', 
				$epg_font_size, $epg_font_size_ops, 700, true);
			#############deinterlace####################
			$deinterlace = isset($plugin_cookies->deinterlace) ? $plugin_cookies->deinterlace : 'bob';
			$deit_ops = array();
			$deit_ops['0'] = 'Выкл.';
			$deit_ops['blend'] = 'blend';
			$deit_ops['bob'] = 'bob';
			$deit_ops['discard'] = 'discard';
			$deit_ops['linear'] = 'linear';
			$deit_ops['mean'] = 'mean';
			$deit_ops['x'] = 'x';
			$deit_ops['yadif'] = 'yadif';
			$deit_ops['yadif2x'] = 'yadif2x';
			#hd_print("deinterlace--->$deinterlace");
			$this->add_combobox
			(
				$defs,
				'deinterlace',
				'Деинтерлейс:',
				$deinterlace, $deit_ops, 700, true
			);
			
			$this->add_button
            (
                $defs,
                'page2',
                '',
                'Настройки далее ==>',
                700
            );
		}
		else if ($this->page_num == 2)
		{
        
		$this->add_button
            (
                $defs,
                'page1',
                'Настройки страница 2 из 2             ',
                '<== На первую страницу настроек',
                700
            );
		
			//////////////////////////record/////////////////////////////////////
			$recdata_ops = array();
			$recdata_ops['/D'] = 'Первый HDD/USB-диск';
			$recdata_ops[1] = 'SMB папка';
			foreach (glob('/tmp/mnt/storage/*') as $file) 
				if (is_dir($file)) $recdata_ops[$file] = ' -'.substr($file,17,strlen($file));
		/////////////////////////////////////////////////////////////////////
			$this->add_combobox($defs,
            'recdata', 'Сохранять записи на:',
            $recdata, $recdata_ops, 700, true);		
			if ($recdata !== '1') {
				$recdata_dir_ops = array();
				$recdata_dir_ops["$recdata"] = '/';
				foreach (glob("$recdata/*") as $file)
				if (is_dir($file)) {
				if (preg_match('|/tmp/mnt/|', $file))
					$file	= basename($file);
				else
					$file	= substr($file,3,strlen($file));
				$recdata_dir_ops['/'.$file.'/'] = $file;
				}
				$this->add_combobox($defs,
						'recdata_dir', 'Каталог:',
						$recdata_dir, $recdata_dir_ops, 700, true);
			}	
			elseif ($recdata == '1') {
				 $this->add_button($defs,
					'recdata_path_smb',
					'Путь, логин и пароль SMB:',
					'Изменить',
					700
				);	
			}
			/////////////////////////////////////////////////////////////////////
			$use_local_icons = array();

            $use_local_icons['0'] = 'Иконки портала';
            $use_local_icons['1'] = 'Грузить архивом с сервера';

            $local_icons = isset($plugin_cookies->use_local_icons) ? $plugin_cookies->use_local_icons : '1';

            $this->add_combobox
            (
                $defs,
                'local_icons',
                'Иконки каналов:',
                $local_icons, $use_local_icons, 0, true
            );
			////////////////////////////////////////////////////////////////
			$this->add_button
            (
                $defs,
                'export_tvclub_settings',
                'Сделать backup настроек',
                'Dune => Накопитель',
                0
            );
			$this->add_button
            (
                $defs,
                'import_tvclub_settings',
                'Восстановить backup настроек',
                'Накопитель => Dune',
                0
            );	
			////////////////////////////////////////////////////////////////
			$this->add_button
            (
                $defs,
                'restart',
                '',
                'Перезагрузить плагин',
                700
            );
		}
        return $defs;
    }
            

    public function get_control_defs(MediaURL $media_url, &$plugin_cookies)
    {
        $this->tv->unload_channels();
        return $this->do_get_control_defs($plugin_cookies);
    }
	public function do_get_fav_show_defs()
    {
        $defs = array();
        ControlFactory::add_label($defs, "", "Для применения изменений необходима перезагрузка плагина.");
		ControlFactory::add_label($defs, "", "Перезагрузить плагин сейчас?");
        $this->add_close_dialog_and_apply_button($defs,
             'restart_pl', 'Да', 250);
        $this->add_close_dialog_button($defs,
            'Нет', 250);
        return $defs;
    }
	public function do_get_restart_defs()
    {
        $defs = array();
        ControlFactory::add_label($defs, "", "Для применения изменений необходима перезагрузка приставки.");
		ControlFactory::add_label($defs, "", "Перезагрузить плеер сейчас?");
       $this->add_close_dialog_and_apply_button($defs,
            'restart', 'Да', 250);
        $this->add_close_dialog_button($defs,
            'Нет', 250);
        return $defs;
    }
    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        hd_print('Setup: handle_user_input:');
        foreach ($user_input as $key => $value)
            hd_print("  $key => $value");
		$need_close_dialog = false;
		$need_reset_controls = false;
		$post_action = null;
        #hd_print("Setup: changing $control_id value to $new_value");

        hd_silence_warnings();
        if ($user_input->action_type === 'confirm' || $user_input->action_type === 'apply')
        {

        $control_id = $user_input->control_id;
        $new_value = $user_input->{$control_id};	    
        if ($control_id === 'show_tv')
                $plugin_cookies->show_tv = $new_value;
        else if ($control_id === 'show_vod')
                $plugin_cookies->show_vod = $new_value;


		else if($control_id === 'http_caching')
			{
			$buf_time = intval($new_value);
			$plugin_cookies->buf_time = $buf_time;
			return ActionFactory::reset_controls(
				$this->do_get_control_defs($plugin_cookies));
			}
		else if ($control_id == 'deinterlace')
            {
            $deinterlace = strval($new_value);
			$plugin_cookies->deinterlace = $deinterlace;
			$msg = 'Деинтерлейс изменен!';
			$need_reset_controls = true;
			return ActionFactory::reset_controls(
				$this->do_get_control_defs($plugin_cookies));
            }
		else if ($control_id === 'timeshift')
			{
			$p_var = $new_value;
			$plugin_cookies->time_shift = $new_value;
			$this->session->set_set_pro($control_id, $p_var);
			}
		else if ($control_id === 'epg_shift')
			{
			$plugin_cookies->epg_shift = $new_value;
			$this->session->set_set_pro($control_id, $new_value);
			}
		else if ($control_id === 'stream_server')
			{
			$p_var = $new_value;
			#hd_print("NEW_SERVER----->$p_var");
			$plugin_cookies->stream_server = $new_value;
			$this->session->set_server($control_id, $p_var);
			return ActionFactory::reset_controls(
				$this->do_get_control_defs($plugin_cookies));
			}
		else if ($control_id === 'timezone')
			{
			$p_var = $new_value;
			#hd_print("NEW_TIMEZONE----->$p_var");
			$plugin_cookies->timezone = $new_value;
			$this->session->set_timezone($control_id, $p_var);
			return ActionFactory::reset_controls(
				$this->do_get_control_defs($plugin_cookies));
			}
		////////////////////////////////////////////////////
		else if ($control_id === 'page1')
            {
			$need_reset_controls = true;
            $this->page_num = 1;
                return ActionFactory::reset_controls(
                    $this->do_get_control_defs($plugin_cookies), null, 1);
            }
		else if ($control_id === 'page2')
            {
			$need_reset_controls = true;
            $this->page_num = 2;
                return ActionFactory::reset_controls(
                    $this->do_get_control_defs($plugin_cookies), null, 1);
            }
		else if ($control_id === 'local_icons')
			{
            $plugin_cookies->use_local_icons = $new_value;
				$defs = array();	
				$defs = $this->do_get_fav_show_defs();
				return  ActionFactory::show_dialog
				("Необходима перезагрузка плагина",
				$defs,
				true);
			}
		else if ($control_id === 'restart_pl')
			{
                $url = 'plugin_launcher://tvclub';
				return ActionFactory::launch_media_url($url);
			}
		///////////////////////////////////////////////////
		else if ($control_id == 'epg_font_size')
			{
			$plugin_cookies->epg_font_size = $new_value;
			return ActionFactory::reset_controls(
				$this->do_get_control_defs($plugin_cookies));
			}
		///////////////////////////////record/////////////////////////////////////////
		else if ($control_id === 'recdata_dir')
			{
			$plugin_cookies->recdata_dir = $user_input->recdata_dir;
			$perform_new_action = UserInputHandlerRegistry::create_action(
            $this, 'reset_controls');
				return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
			}
		else if ($control_id === 'recdata')
			{
			$plugin_cookies->recdata = $user_input->recdata;
			$perform_new_action = UserInputHandlerRegistry::create_action(
            $this, 'reset_controls');
				return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
			}
		else if ($control_id === 'recdata_path_smb'){
				$defs = $this->do_get_recdata_path_smb_defs($plugin_cookies);
					
					return  ActionFactory::show_dialog
							(
								"Логин и пароль SMB папки",
								$defs,
								true
							);
				}
		else if ($control_id === 'recdata_path_smb_apply'){
				$plugin_cookies->recdata_smb_user = $user_input->recdata_smb_user;
				$plugin_cookies->recdata_smb_pass = $user_input->recdata_smb_pass;
				$plugin_cookies->recdata_ip_path = $user_input->recdata_ip_path;
				$perform_new_action = UserInputHandlerRegistry::create_action(
						$this, 'reset_controls');
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
			}
		else if ($control_id === 'ip_path_smb'){
				$defs = $this->do_get_ip_path_smb_defs($plugin_cookies);
					
					return  ActionFactory::show_dialog
							(
								"Логин и пароль SMB папки",
								$defs,
								true
							);
				}
		/////////////////////////////////////////////////////////////////////////
		else if ($control_id === 'export_tvclub_settings')
			{	if (!file_exists('/D/'))
				return ActionFactory::show_title_dialog("Подключите накопитель к плееру и повторите!");
                $mci = '/config/tvclub_plugin_cookies.properties';
				shell_exec("mkdir -p /D/tvclub_backup && cp /config/tvclub_plugin_cookies.properties /D/tvclub_backup/");
				if (!file_exists('/D/tvclub_backup/tvclub_plugin_cookies.properties'))
				{
					return ActionFactory::show_title_dialog("Что-то прошло не так!!!");
				}
				else
				{
				return ActionFactory::show_title_dialog("Backup создан в каталоге 'tvclub_backup'!!!");
				}
			}
		else if ($control_id === 'import_tvclub_settings')
			{	if (!file_exists('/D/tvclub_backup/tvclub_plugin_cookies.properties'))
				return ActionFactory::show_title_dialog("Backup не найден!");
                $mci = '/config/tvclub_plugin_cookies.properties';
				shell_exec("cp -r /D/tvclub_backup/tvclub_plugin_cookies.properties $mci  > /dev/null &");
				$defs = array();	
				$defs = $this->do_get_restart_defs();
				return  ActionFactory::show_dialog
				("Backup восстановлен!!!",
				$defs,
				true);
			}
		else if ($control_id === 'reset_controls')
				{
				return ActionFactory::reset_controls(
					$this->do_get_control_defs($plugin_cookies));
				}
		else if ($control_id === 'restart')
			{
                shell_exec('killall shell');
				 break;
			}
            $need_reset_controls = true;
        
	    if ($control_id === 'edit_subscription')
		{
			return $this->do_get_edit_subscription_action($plugin_cookies, $this);
		}
        else if ($control_id === 'edit_pcode')
		{
			hd_print("pcod");
			return $this->do_get_edit_pcode_action();
		}
	    elseif ($control_id === 'apply_sub')
		{
			if ($user_input->login === '' || $user_input->pass === '')
				{
					return ActionFactory::show_error(false,'Error',array('Поле Логин или Пароль не может быть пустым.'));
				}
				

			$islogged = $this->session->is_logged_in();
			if ($islogged == true)
				{
					$this->session->unset_login();
				}
			try
				{
					$this->session->get_new_login($user_input->login, $user_input->pass, &$plugin_cookies);
				}
			catch (DuneException $e)
				{
					#hd_print("nooooooooooooooooooooo");
					return $this->session->api_exception($e,'login failed.', false);
					//
					#$post_action = $e->get_error_action();
				}
			if ($plugin_cookies->is_login_correct == true)
			hd_print("---------------------------------");
								{$plugin_cookies->login = $user_input->login;
								$plugin_cookies->pass = $user_input->pass;}
			
			$need_close_dialog = true;
                	$need_reset_controls = true;
                	#$plugin_cookies->logiin = true;
			hd_print("gfhdhfh");
		}
	    elseif ($control_id === 'pcode')
	    {
		if ($user_input->new_pcode_copy !== $user_input->new_pcode)
		{
		$no_ident = 'Новый код и код подтверждения - не одинаковы!!!';
		hd_print("not korrekt");
		return ActionFactory::show_title_dialog($no_ident);
		}
		else 
		{
		$akk_id = $plugin_cookies->token;
		$new_pass_sex = $user_input->new_pcode;
		$old_pass_sex = $user_input->current_pcode;
		#$plugin_cookies->pass_sex = intval($new_pass_sex);
		#hd_print("akk_id------>$akk_id");
		$password_set = HD::get_daten('json/set?token='.$akk_id . "&new_code=$new_pass_sex&old_code=$old_pass_sex", null);
		hd_silence_warnings();
		#hd_print("password_set------>$password_set");
		$res = json_decode($password_set);
		$tt = '';
		$tt = $res->error->code;
		$ttt = '';
		$ttt = $res->settings->updated;
		$msg = '';
		if($tt == '21')
			{
			$msg = 'Текущий пароль неверен!!!';
			hd_print("response1------>$msg ".$res->error->code);
			$need_reset_controls = true;
			$need_close_dialog = true;
			return ActionFactory::show_title_dialog($msg);
			}
		if($ttt == '1')
			{
			$msg = 'Пароль изменен!';
			hd_print("response1------>$msg ".$res->settings->updated);
			$need_reset_controls = true;
			$need_close_dialog = true;
			}
		hd_restore_warnings();	
		}
  	    }
	    elseif ($control_id === 'close')
	    {
	     //return null;
  		$need_reset_controls = true;
  		$need_close_dialog = true;
  	    }
		/////////////////////////////////////////////////////////////////////////////////////
		else if ($control_id === 'abonement')
            {
				$account_info = $this->session->get_akk_pro();
				$abo = $account_info->account->info->login;
				#hd_print("account_info----->$abo");
				$this->account = $account_info->account;
				
				$post_action = null;
				
				$text = '  Ваше имя: ' . $account_info->account->info->name;
				$text_0 = '  Ваш логин: ' . $abo;
				$text_0_1 = '  Ваш E-Mail: ' . $account_info->account->info->mail;
				$text_3 = '  Заканчивается: ' . $end_date;
				$defs = array();
				
				ControlFactory::add_img_label($defs, '', "<icon>/persistfs/plugins/tvclub/icons/special/id_ico.png</icon><text dy='7' size='normal'>$text</text>", 0, 0, 0);
				ControlFactory::add_img_label($defs, '', "<icon>/persistfs/plugins/tvclub/icons/special/abo_ico.png</icon><text dy='7' size='normal'>$text_0</text>", 0, 0, 0);
				ControlFactory::add_img_label($defs, '', "<icon>/persistfs/plugins/tvclub/icons/special/email_ico.png</icon><text dy='7' size='normal'>$text_0_1</text>", 0, 0, 0);
				$this->add_button($defs,'services',"",'    Ваш тарифный план',550);
				ControlFactory::add_label($defs, "", '                                                                 ');
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs, 'setup', 'Ok', 150,  $post_action);

				return ActionFactory::show_dialog('Ваша подписка', $defs, true);
            }
            else if ($control_id === 'services')
            {
            
            $i = 1;
            $n = count($this->account->services) - 2;
            foreach ($this->account->services as $services){
            if($services->id !== 21){
            	ControlFactory::add_label($defs, 'Услуги:', $services->type ." " .$services->name);
            	ControlFactory::add_label($defs, 'Подписка:', date("Y-m-d H:i:s" , $services->expire));
            	}
            	if($i <= $n){
            	ControlFactory::add_label($defs, '________', "__________________________");
            	++$i;
            	}
             }
                ControlFactory::add_custom_close_dialog_and_apply_buffon($defs, 'setup', 'Ok', 150,  $post_action);

			return ActionFactory::show_dialog('Ваш тарифный план', $defs, true);            
            }
		/////////////////////////////////////////////////////////////////////////////////////
	    else
	    {
	     //return null;
  		$need_reset_controls = true;
  		$need_close_dialog = true;
  	    }
        }
	if ($need_reset_controls)
        {
            $defs = $this->do_get_control_defs($plugin_cookies);
	    #hd_print("uuuuuuuuuuuuu");
            $reset_controls_action = ActionFactory::reset_controls(
                $defs, $post_action);

            if ($need_close_dialog)
            {
                return ActionFactory::close_dialog_and_run(
                    $reset_controls_action);
            }

            return $reset_controls_action;
         }
		 return ActionFactory::reset_controls(
           $this->do_get_control_defs($plugin_cookies));
		hd_restore_warnings();
    }

    private function do_get_edit_subscription_defs(&$plugin_cookies, $handler, $add_params)
    {
        $defs = array();

        $login = isset($plugin_cookies->login) ? $plugin_cookies->login : '';
        $pass = isset($plugin_cookies->pass) ? $plugin_cookies->pass : '';

        ControlFactory::add_text_field($defs,
            $handler, $add_params,
            'login', 'Логин на tvclub.us:',
            $login, false, false, false, false, 750);

        ControlFactory::add_text_field($defs,
            $handler, $add_params,
            'pass', 'Пароль на tvclub.us:',
            $pass, false, true, false, false, 750);

        ControlFactory::add_vgap($defs, 50);

        ControlFactory::add_button($defs,
            $handler, $add_params,
            'apply_sub', null, 'Ввести', 300);

        ControlFactory::add_vgap($defs, -3);

        ControlFactory::add_close_dialog_button($defs,
            'Отмена', 300);
			
		#ControlFactory::add_label($defs, '', '');
		ControlFactory::add_img_label($defs, '', '<text dy="7" size="small"> Нажмите </text><icon>gui_skin://special_icons/controls_button_blue.aai</icon><text dy="7" size="small"> для вызова экранной клавиатуры</text>', 0, 0, 0);
        return $defs;
    }
   public function do_get_edit_subscription_action(&$plugin_cookies, $handler, $add_params = null) 
	{
		$message = 'Введите данные логин и пароль';
        	return ActionFactory::show_dialog(
            		$message,
            		$this->do_get_edit_subscription_defs(
                	$plugin_cookies, $handler, $add_params),
            		true);

	}

    private function do_get_edit_pcode_defs()
    {
        $defs = array();

        $this->add_text_field($defs,
            'current_pcode', 'Текущий код:',
            '', true, true, false,false,750);

        $this->add_text_field($defs,
            'new_pcode', 'Новый код:',
            '', true, true, false,false,750);

        $this->add_text_field($defs,
            'new_pcode_copy', 'Подтвердите код:',
            '', true, true, false,false,750);

        $this->add_vgap($defs, 50);

        $this->add_button($defs,
            'pcode', null, 'Изменить', 300);

        $this->add_vgap($defs, -3);

        $this->add_close_dialog_button($defs,
            'Отменить', 300);
		ControlFactory::add_img_label($defs, '', '<text dy="7" size="small"> После успешной смены кода, окно будет закрыто.</text>', 0, 0, 0);
        return $defs;
    }

    private function do_get_edit_pcode_action()
    {
        return ActionFactory::show_dialog(
            'Смена кода для закрытых каналов',
            $this->do_get_edit_pcode_defs(),
            true);
    }


}

///////////////////////////////////////////////////////////////////////////
?>
