<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/hashed_array.php';
require_once 'lib/tv/abstract_tv.php';
require_once 'lib/tv/default_epg_item.php';
require_once 'lib/user_input_handler_registry.php';

require_once 'tv_channel.php';

///////////////////////////////////////////////////////////////////////////

class MyPlugINTv extends AbstractTv implements UserInputHandler
{
    private $servers;
    public $cookie = array();
    public function get_handler_id() { return "tv"; }
    public function __construct($session)
    {
		UserInputHandlerRegistry::get_instance()->register_handler($this);
        parent::__construct(
            AbstractTv::MODE_CHANNELS_N_TO_M,
            MyPlugIN_Config::TV_FAVORITES_SUPPORTED,
            true);
		$this->session = $session;
		
		UserInputHandlerRegistry::get_instance()->
            register_handler($this);
    }

    public function get_fav_icon_url()
    {
        return 'plugin_file://icons/genres/fav.png';
    }

    ///////////////////////////////////////////////////////////////////////
    public function newload(&$plugin_cookies)
	{
		hd_print('unload');
		if(is_null($this->channels) && is_null($this->groups))
			$this->load_channels($plugin_cookies);
	}
    ///////////////////////////////////////////////////////////////////////
    /**
     * @param $plugin_cookies
     */
    protected function load_channels(&$plugin_cookies)
    {
        $this->session->check_login($plugin_cookies);
        $this->channels = new HashedArray();
        $this->groups = new HashedArray();
        $group_tmp = null;
        $buffer = isset($plugin_cookies->buf_time) ? $plugin_cookies->buf_time : 0;
		$hide_items = isset($plugin_cookies->hide_items) ? $plugin_cookies->hide_items : '';
		$hided_channels = isset($plugin_cookies->hided_channels) ? $plugin_cookies->hided_channels : 'no';
		$hided_categories = isset($plugin_cookies->hided_categories) ? $plugin_cookies->hided_categories : 'no';
		$hide_category_items = isset($plugin_cookies->hide_category_items) ? $plugin_cookies->hide_category_items : '';
        if ($this->is_favorites_supported())
        {
            $this->groups->put( new FavoritesGroup(
                $this,
                '__favorites',
                'Избранные',
                'plugin_file://icons/genres/fav.png'));
        }

        $this->groups->put( new AllChannelsGroup(
            $this,
            'Все каналы',
            'plugin_file://icons/genres/all.png'));
		
        $category = $this->session->get_group_tv();
		#hd_print("category---------->$category");
		$chanel_number = 1;
		foreach ($category->groups as $tv_category)
        {
            $cha_tv = $this->session->get_group_tv_channel($tv_category->id);
			####################
			if($hided_categories == 'no')
				{
				$tv_category_id = intval($tv_category->id);
				$qal = explode('|', $hide_category_items);
				
				if (in_array($tv_category_id, $qal)) {
					#echo "Нашел in array!!!";
					continue;
				}
				}
			####################
                $this->groups->put( new DefaultGroup(
                    $tv_category->id,
                    strval($tv_category->name_ru),
					MyPlugIN_Config::TV_CHANNEL_GROUP_ICON_PATH . strval($tv_category->id) . ".png"));
				
                foreach ($cha_tv->channels as $tvchannels)
                {
					///////////////////////////////////////////////////////////////////////////////////
					$local_icon = (isset($plugin_cookies->use_local_icons) ? $plugin_cookies->use_local_icons : '1');
                    
                    $icon = '';
                    if ($local_icon == '0')
                        $icon = "http://tvclub.us/logo/200_115_0/" . ($tvchannels->info->id) . '.png';####
                    else
                        $icon = $this->session->get_channel_icon($tvchannels->info->id);#####
				///////////////////////////////////////////////////////////////////////////////////
                    $stalker_channel = new MyPlugIN_Channel
					(
                                strval($tvchannels->info->id),
                                strval($tvchannels->info->name),
                                $icon,
                                "",
                                $chanel_number,
                                18,
                                7,
                                $buffer,
                                intval($tvchannels->info->protected),
                                intval($tvchannels->info->records),
								intval($tvchannels->info->id)
                            );
					########hide########
					if($hided_channels == 'no')
					{
					$ch = strval($tvchannels->info->id);
					$t = ListUtil::is_in_list($hide_items, $ch);
                    if ($ch == $t)
                   
						 continue;
					}
					
					####################
					
                    $this->channels->put($stalker_channel);

                    $group = $this->groups->get($tv_category->id);

                    // Link group and channel.
                    $stalker_channel->add_group($group);
                    $group->add_channel($stalker_channel);
					++$chanel_number;
                }
				#remove empty groups
				$temp_groups = new HashedArray();
				foreach($this->get_groups() as $g)
					if($g->is_favorite_channels() or ($g->get_channels($plugin_cookies) != NULL and $g->get_channels($plugin_cookies)->size()))
						$temp_groups->put($g);
					else
						hd_print("Group " . $g->get_title() . " removed: no channels");
				$this->groups = $temp_groups;
		}
    }
	//////////////////////////////////////////////////////////////////////////
	private function replace_desc($str)
	{
	$in_array = array
        (
            chr(9),
            chr(10),
            chr(13)
        );

        $str = str_replace($in_array, "", $str);
		$str = str_replace('\n', " ", $str);
	return $str;
	}
    ///////////////////////////////////////////////////////////////////////////
    public function get_tv_playback_url($channel_id, $archive_ts, $protect_code, &$plugin_cookies)
    {
	$url = false;
	$buf_time = isset($plugin_cookies->buf_time) ? $plugin_cookies->buf_time : 0;
	$this->session->check_for_arch();
	$url = $this->session->get_url($channel_id, $protect_code, $archive_ts, $plugin_cookies);
    hd_print("END_URL:--->>>  $url");
	
	return $url;
    }
    ///////////////////////////////////////////////////////////////////////////

    public function get_day_epg_iterator($channel_id, $day_start_ts, &$plugin_cookies)
    {
	$tzone = exec("date +%z");
	$tzone_sec = intval(substr($tzone, 1, 2)) * 3600 + intval(substr($tzone, 3, 2)) * 60;
	if (substr($tzone, 0, 1) == "-") 
		{
		$tzone_sec = -$tzone_sec;
		}
	
	hd_silence_warnings();
    $epg = array();
	$epg_shift = isset($plugin_cookies->epg_shift) ? $plugin_cookies->epg_shift : '0';
    #hd_print("day_start_ts: ---->>>  $day_start_ts");
	#hd_print("tzone_sec: ---->>>  $tzone_sec");
	if(preg_match('/radio_/i', $channel_id))
		{
            $epg[] =
                new DefaultEpgItem(
                    "ТВ Программа отсутствует",
                    "",
                    "",
                    0/*intval($epg_item->stop_time)*/);
	}
	else
	{
		$doc_epg = $this->session->get_stalker_epg($day_start_ts,$channel_id,$this->cookie,&$plugin_cookies);
		#hd_print("doc_epg---------------->$doc_epg");
        if(preg_match('/Undefined variable:/i', $doc_epg))
        	{
				hd_print("ERROR");
            		$epg[] =
                		new DefaultEpgItem(
                    			"ТВ Программа отсутствует!",
                    			"",
                    			"",
                    			0);
        	}

	else
		{
		#hd_print("EPG---->OK");
		$doc_epg = json_decode($doc_epg);
		foreach ($doc_epg->epg->channels as $item)
		{
			foreach ($item->epg as $epg_item)
			{
			$epg[] =
			new DefaultEpgItem(
			strval($epg_item->text),
			htmlspecialchars_decode($this->replace_desc($epg_item->description)),
			$epg_item->start,
			$epg_item->end);
			}
		}
		}
		
	}
	return new EpgIterator(
			$epg,
			$day_start_ts - $tzone_sec,
			$day_start_ts + 86400 * 7);
	hd_restore_warnings();
    }
	public function get_kuk($local_icon)
    { 
		$ini = parse_ini_file('/config/tvclub_plugin_cookies.properties');
		#hd_print("use_local_icons_ini------------------->". $ini['use_local_icons']);
		if ($ini['use_local_icons'] == '0'){
		$local_icon = '0';	
		}
		else
		{
		$local_icon = '1';
		}
		#hd_print("local_icon------------------->$local_icon");
		
        return $local_icon;
    }
    public function get_archive(MediaURL $media_url)
    { 
		$k = '';
		$k = $this->get_kuk($k);
		#hd_print("KKKKKKKK------------------->$k");
		if($k == '0')
		{
			return;
		}
		else
		{
        return $this->session->get_archive();
		}
    }
	//////////////////////////////NEW////////////////////////////////////
	 	
	private function get_sample_dialog_defs($n)
    {
		$version = VERSION_MAJOR . '.' . VERSION_MINOR . '.' . VERSION_SUBMINOR;
        $defs = array();
		ControlFactory::add_smart_label($defs,"", '<text color="10" size="small">Плагин tvclub.us: </text><text size="small">Версия ' . $version . '</text>');
		ControlFactory::add_smart_label($defs,"", '<text color="10" size="small">Сделали: </text><text size="small">igores и micha86</text>');
		ControlFactory::add_smart_label($defs,"", '<text color="10" size="small">Сайт: </text><text size="small">https://igores.ru/forum</text>');	
		ControlFactory::add_label($defs, null,
            ' ');
        $this->add_close_dialog_button($defs,
            'ОK', 250);
        return $defs;
    }

	/////////////////////////
	protected function add_combobox(&$defs,
        $name, $title, $initial_value, $value_caption_pairs, $width,
        $need_confirm = false, $need_apply = false)
    {
        ControlFactory::add_combobox($defs, $this, null,
            $name, $title, $initial_value, $value_caption_pairs, $width,
            $need_confirm, $need_apply);
    }
        protected function add_button(&$defs,$name, $title, $caption, $width)
    {
        ControlFactory::add_button($defs, $this, null,
            $name, $title, $caption, $width);
    }
	protected function add_close_dialog_and_apply_button(&$defs,
        $name, $caption, $width)
    {
        $params = array('button_caption_centered' => 1);
        ControlFactory::add_close_dialog_and_apply_button($defs,
            $this, null,
            $name, $caption, $width, $params);
    }

    protected function add_close_dialog_button(&$defs,
        $caption, $width)
    {
        $params = array('button_caption_centered' => 1);
        ControlFactory::add_close_dialog_button($defs,
            $caption, $width, $params);
    }
	protected function add_text_field(&$defs, $name, $title, $initial_value, $numeric, $password, $has_osk, $always_active, $width, $need_confirm = false, $need_apply = false) {
        ControlFactory::add_text_field($defs, $this, null,
                        $name, $title, $initial_value,
                        $numeric, $password, $has_osk, $always_active, $width,
                        $need_confirm, $need_apply);
    }
	private function get_setup_dialog_defs(&$plugin_cookies)
    {
		$settings = $this->session->get_settings_pro();
		$defs = array();
		$doc = $this->session->get_settings_pro();
		
		$this->servers = $doc->settings->lists->servers;		      
		
		################buffer####################
		$buf_time = isset($plugin_cookies->buf_time) ? $plugin_cookies->buf_time : 0;
			#hd_print("buff:$buf_time");
			$show_buf_time_ops = array();
			$show_buf_time_ops['0'] = 'По умолчанию';
			$show_buf_time_ops['500'] = '0.5 сек';
			$show_buf_time_ops['1000'] = '1 сек';
			$show_buf_time_ops['1500'] = '1.5 сек';
			$show_buf_time_ops['2000'] = '2.0 сек';
			$show_buf_time_ops['2500'] = '2.5 сек';
			$show_buf_time_ops['3000'] = '3 сек';
			$show_buf_time_ops['5000'] = '5 сек';
			$show_buf_time_ops['8000'] = '8 с';
			$show_buf_time_ops['10000']	= '10 сек';
			$show_buf_time_ops['15000'] = '15 с';
			$this->add_combobox
        		(
            			$defs,
            			'http_caching',
            			'Время буферизации:',
            			$buf_time, $show_buf_time_ops, 1000, true
        		);
		#################server###################
		$stream_server_ops = array();
		$stream_server = intval($settings->settings->current->server->id);
		#hd_print("stream_server--->$stream_server");
		foreach ($settings->settings->lists->servers as $pair)
			$stream_server_ops[intval($pair->id)] = strval($pair->name) . ' (загружен на ' . strval($pair->load) . '% из ' . strval($pair->power) . ')';
		$this->add_combobox($defs,
			'stream_server', 'Сервер вещания:',
			$stream_server, $stream_server_ops, 1000, true);
	    $this->add_button($defs,'servers',"Загрузка серверов:",'Показать',1000);		
		//////////////////////////////////////////////
		#############deinterlace####################
		$deinterlace = isset($plugin_cookies->deinterlace) ? $plugin_cookies->deinterlace : 'bob';
			$deit_ops = array();
			$deit_ops['0'] = 'Выкл.';
			$deit_ops['blend'] = 'blend';
			$deit_ops['bob'] = 'bob';
			$deit_ops['discard'] = 'discard';
			$deit_ops['linear'] = 'linear';
			$deit_ops['mean'] = 'mean';
			$deit_ops['x'] = 'x';
			$deit_ops['yadif'] = 'yadif';
			$deit_ops['yadif2x'] = 'yadif2x';
			#hd_print("deinterlace--->$deinterlace");
			$this->add_combobox
			(
				$defs,
				'deinterlace',
				'Деинтерлейс:',
				$deinterlace, $deit_ops, 1000, true
			);	
		//////////////////////////////////////////////
		$this->add_close_dialog_and_apply_button($defs,
            'setup_apply', 'Применить', 300);
        $this->add_close_dialog_button($defs,
            'Отмена', 300);
		ControlFactory::add_smart_label($defs,"", '<icon>gui_skin://small_icons/info.aai</icon><text dy="5" color="5" size="small"> На некоторых плеерах нужно для применения переключить канал!!!</text>');
		#ControlFactory::add_smart_label($defs,"", '<text dy="5" color="5" size="small">      применения переключить канал!!!</text>');
        return $defs;
    }
	public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        #hd_print('TV entry handler: handle_user_input:');
        foreach ($user_input as $key => $value)
            #hd_print("key--------> $key => value--------->$value");
		
		$control_id = $user_input->control_id;

        if (isset($user_input->{$control_id}))
        {
            $new_value = $user_input->{$control_id};
        #    hd_print("Setup_test: changing $control_id value to $new_value");
        }
        else
            $new_value = null;
        
        if ($user_input->control_id == 'dialog')
        {
			$defs = $this->get_sample_dialog_defs($plugin_cookies);
			$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
                    return ActionFactory::show_dialog_glass('Информация', $defs,true, $preferred_width = 700,$attrs);
        }
		
		if ($user_input->control_id == 'setup_dialog')
        {
			$defs = $this->get_setup_dialog_defs($plugin_cookies);
			$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
                    return ActionFactory::show_dialog_glass('Быстрые настройки', $defs,true, $preferred_width = 1530,$attrs);
        }
        if ($user_input->control_id == 'servers')
        {
			$defs = array();
			
			ControlFactory::add_label($defs, 'Сервер', "Нагрузка / Мощность");
			foreach($this->servers as $server){
			ControlFactory::add_label($defs, $server->name, '      ' .$server->load .'% / ' .$server->power  );
			}
			$this->add_close_dialog_button($defs,'Закрыть', 200);
			#$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
                    return ActionFactory::show_dialog_glass('Загрузка серверов:', $defs,true, $preferred_width = 800,$attrs);
        }
		
		if ($user_input->control_id == 'setup_apply')
        {
		$channel_id = $user_input->plugin_tv_channel_id;
		#	hd_print("channel_id -----------> $channel_id");
		$strim = $user_input->stream_server;
        #    hd_print("Setup: changing strim value to $strim");
		$buf_tv_1 = $user_input->http_caching;
		$deint = $user_input->deinterlace;
        #    hd_print("Setup: changing buf_tv value to $buf_tv_1");
		if(isset($user_input->http_caching))
		{
		$plugin_cookies->buf_time = $buf_tv_1;
		$plugin_cookies->deinterlace = $deint;
        $this->session->set_server($control_id, $strim);
		#hd_print("Setup: changing buffer value to $buff");
		$this->session->get_settings_pro();
		################################
		shell_exec ('echo EA15BF00 > /proc/ir/button');
		shell_exec ('echo FB04BF00 > /proc/ir/button');
		################################
		}
		}
        return null;
    }
	/////////////////////////////////////////////////////////////////
	public function get_tv_info(MediaURL $media_url, &$plugin_cookies)
    {
        #$this->session->ensure_logged_in($plugin_cookies);

        $info = parent::get_tv_info($media_url, &$plugin_cookies);

        $info[PluginTvInfo::actions] = array(

            GUI_EVENT_KEY_DUNE => UserInputHandlerRegistry::create_action($this, 'dialog', null),
			GUI_EVENT_KEY_SETUP => UserInputHandlerRegistry::create_action($this, 'setup_dialog', null),

        );
        return $info;
    }
	////////////////////////
}

///////////////////////////////////////////////////////////////////////////
?>
