<?php
///////////////////////////////////////////////////////////////////////////
const TVCLUB_ARCHIVE_URL_PREFIX = 'http://www.igores.ru/dune/tvclub';
const TVCLUB_ARCHIVE_ID = 'main';
/////////////////////////////////////////////
	const VERSION_MAJOR                     = '1';
    const VERSION_MINOR                     = '0';
    const VERSION_SUBMINOR                  = '3';
    const VERSION_DATE                      = '03.10.16';
    const VERSION_TIME                      = '00:00';
    ///////////////////////////////////////////////////////////////////////

class MyPlugIN_Api
{ 
	#const API_URL = '';
	private $cookie = null;
	public $settings = null;
	public $account = null;
	private $is_logged = null;
	private $disk_space = 0;
	private $timezone = '+00:00:00';
    private $timezone_sec = 0;

	public function is_logged_in()
	{ return $this->is_logged; }

	public function get_account($plugin_cookies)
	{ return $this->account; }

	public function get_settings()
	{ return $this->settings; }

///////////////////////////////////////////////////////////////////////////

    	public function api_exception($e, $def_caption, $is_playback)
	{
		$is_mylogin_error = ($e instanceof MyPlugIN_Exception);
        	if (!$is_mylogin_error)
        	{
			if ($e->getMessage() == 0) {
			hd_print('General exception:------------------');
			$text='Неправильный логин или пароль';
			}
			else
			$text=$e->getMessage();
            		hd_print('General exception: ' . $e->getMessage());
            		$title = !$is_playback ? 'Оповещение' :
                	'Не удалось подключиться к Интернету.';
            		$text_lines = $is_playback ? array() :
                	array(
                 		//'Не удалось подключиться к Интернету.',
                 		$text//$e->getMessage()
                		);
            		return new DuneException(
                	$def_caption, -1,
                		ActionFactory::show_error(false, $title, $text_lines));
						
        	}
        	hd_print('MyPlugIN API exception: ' .
            		'code=' . $e->getCode() . ', message=' . $e->getMessage());

        	$ecode = $e->getCode();
		$emessage = $e->getMessage();
        	#$fatal = $ecode == 5 || $ecode == 6 ||
            		#$ecode == 11 || $ecode == 12 || $ecode == 13;

		$fatal = $ecode == 12 && $emessage == 'Authentification error' || $ecode == 17 || $ecode == 5;
        	if ($fatal)
            		$this->unset_login();

		#if ($ecode == 2 || $ecode == 4)
		#	{
		#		$this->is_logged = false;
		#	}
        	$title = !$is_playback ? 'Error' : $emessage;
        	$text_lines = $is_playback ? array() :
            	array('Описание: ' . $emessage,
                	'Код ошибки: ' . $ecode);
        	return new DuneException(
            		$def_caption, $ecode,
            		ActionFactory::show_error($fatal, $title, $text_lines));
		
	}
///////////////////////////////////////////////////////////////////////////
	public function unset_login()
	{
		hd_print("unset_login");
		$this->cookie = null;
		$this->is_logged = false;
		$this->account = null;
		$this->settings = null;
		
	}
///////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////
	public function check_login($plugin_cookies)
	{
		hd_print("check_login");
		#hd_print("cookie:$this->cookie");
		$is_login_correct = isset($plugin_cookies->is_login_correct) ? $plugin_cookies->is_login_correct : false;
		hd_print("is_login_corect:$is_login_correct");
		$is_logged = $this->is_logged_in();
		hd_print("is_logged:$is_logged");
		
		if($this->cookie == ''){
		hd_print("ooopppppps");
		if(isset($plugin_cookies->token))
		$this->cookie = $plugin_cookies->token;
		}
		$is_log = isset($is_logged) ? $is_logged : false;
		if ($is_login_correct == 1 && $is_logged != 1)
		{
			hd_print("Авторизация>");
			$this->login_mylogin($plugin_cookies);
			#hd_print("cookie1:$this->cookie");
		}	
	}

///////////////////////////////////////////////////////////////////////////
	public function logout()
	{
		$this->unset_login();
	}
///////////////////////////////////////////////////////////////////////////
	public function get_sett()
	{
			$set = HD::get_daten("users/" . $this->cookie . "/settings", $this->cookie);
			hd_print("get-setting-- $set");
			$set = json_decode($set);

		return $set;
	}
	
	public function login_mylogin($plugin_cookies)
	{
	$token = isset($plugin_cookies->token) ? $plugin_cookies->token : 0;
	hd_print("login_mylogin");
		if (!isset($plugin_cookies->login))
            		throw new Exception('Логин не введен');
		if (!isset($plugin_cookies->pass))
            		throw new Exception('Пароль не введен');
		$doc = HD::get_token($plugin_cookies->login, $plugin_cookies->pass);
		#hd_print("get_login: --->>> $doc");
		$data = json_decode($doc);
		/////////////////////////////////////////////////////
		if(isset($data->session->token)) {
		hd_print("login is ok");
			$this->is_logged = true;
			$plugin_cookies->is_login_correct = true;
			$this->cookie = $data->session->token;
			$plugin_cookies->token = $data->session->token;
			$this->settings = $data->session->expire;
			$this->account = $data->account;
		}
		else {
		try {
			hd_print("login is not ok->$doc");
			//$data = json_decode($doc);
			}

		catch (Exception $e)
		{
			$this->is_logged = false;
			hd_print("loged falled");
			$plugin_cookies->is_login_correct = false;
			throw $this->api_exception($e,'Ошибка авторизации', false);
		}
		}

		if (isset($data->error)) {
		try {
			$error = 'Error';
			
			throw new Exception($error);

		// Code following an exception is not executed.
			//echo 'Never executed';

			} catch (Exception $e) {
			throw $this->api_exception($e,'General', false);
			}
		}
	}
	public function get_new_login($login, $pass, &$plugin_cookies)
	{
		$doc = HD::get_token($login, $pass);
		hd_print("--->>> get_login2: $doc");
		$data = json_decode($doc);
		/////////////////////////////////////////////////////
		if(isset($data->session->token)) {
		hd_print("login is ok");
			$this->is_logged = true;
			$plugin_cookies->is_login_correct = true;
			$this->cookie = $data->session->token;
			$this->settings = $data->session->expire;
			$this->account = $data->account;
		}
		else {
		try {
		$this->is_logged = false;
		$plugin_cookies->is_login_correct = false;
			hd_print("login is not ok");
			$error = 'Ошибка авторизации';
			
			throw new Exception($error);
			}

		catch (Exception $e)
		{
			$this->is_logged = false;
			hd_print("loged falled");
			$plugin_cookies->is_login_correct = false;
			throw $this->api_exception($e,'Ошибка авторизации', false);
		}
		}
	
	}
///////////////////////////////////////////////////////////////////////////
	
	public function load_radio_list()
		{
			$doc = HD::get_daten("users/".$this->account."/radio-channels" ,$this->cookie);
			//hd_print("--->>> get_list_radio: $doc");
			file_put_contents('/tmp/radio_list.txt', $doc);
			$xml = json_decode($doc);

        		if ($xml === false)
        		{
         		   hd_print("Error: can not parse  document.");
         		   hd_print("text: $doc.");
         		   throw new Exception('Illegal  document');
        		}

        		if ($xml->status !== 'OK')
        		{
        		    hd_print("Error: unexpected node '" . $xml->getName() . "'. Expected: 'response'");
        		    throw new Exception('Invalid document');
        		}
			return $xml;
		}
///////////////////////////////////////////////////////////////////////////
	public function get_channel_list($plugin_cookies)
		{
		$this->check_login($plugin_cookies);
			$doc = HD::get_daten("users/".$this->account."/tv-channels" ,$this->cookie);
            #hd_print("get_list_tv--->>>$doc");
            try
            {
                $data = json_decode($doc);
            }
            catch (Exception $e)
            {
                throw $this->api_exception($e,'get_group_list failed.', true);
            }
            return $data;
        }
	//////////////////////////////////////////
	public function get_real_url($url, $id, &$plugin_cookies)
		{
		#hd_print("url_real--->>>$url");	
		if($url == '')
		{
			return $url;
		}
		else
		{
		$url = $this->get_channel_url($id, $plugin_cookies);
		return $url;
		}
        }
	public function get_channel_url($id, $plugin_cookies)
		{
		$this->check_login($plugin_cookies);
			$doc = HD::get_daten("users/".$this->account."/tv-channels/$id/link" ,$this->cookie);
            #hd_print("get_channel_url--->>>$doc");
            try
            {
                $data = json_decode($doc);
            }
            catch (Exception $e)
            {
                throw $this->api_exception($e,'get_group_list failed.', true);
            }
            return $data;
        }
	//////////////////////////////////////////
	public function get_group_tv_channel($group)
	{
		#hd_print("this->account--->>>" . $this->account);
		$doc = HD::get_daten("json/channels?token=".$this->cookie. '&gid=' . $group . '&limit=200', $this->cookie);
		#hd_print("get_group_tv_channel--->>>$doc");
		try
		{
			$data = json_decode($doc);
		}
		catch (Exception $e)
		{
			throw $this->api_exception($e,'get_channel_list failed.', true);
		}
		
		return $data;	
	}
	public function get_group_tv()
    {
		#hd_print("this->account--->>>" . $this->account);
		$doc = HD::get_daten("json/groups?token=".$this->cookie, $this->cookie);
		#hd_print("get_group_list--->>>$doc");
		try
		{
			$data = json_decode($doc);
		}
		catch (Exception $e)
		{
			throw $this->api_exception($e,'get_group_list failed.', true);
		}
		return $data;	
	}
///////////////////////////////////////////////////////////////////////////
	public function get_stalker_epg($day_start,$channel_id,$sid, &$plugin_cookies)
	{
		#hd_print("day_start--->>>$day_start");
		$doc = HD::get_daten('json/epg?token='.$this->cookie.'&channels='.$channel_id.'&time='.$day_start.'&period=28', $this->cookie);
			#hd_print("doc epg--->>>$doc");
       	 	if (is_null($doc))
            	throw new Exception('Can not fetch epg');
        
		
		return $doc;

	}
///////////////////////////////////////////////////////////////////////////
	public function get_url($channel_id, $protect_code, $gmt, &$plugin_cookies)
     {
		$buf_time = isset($plugin_cookies->buf_time) ? $plugin_cookies->buf_time : 0;
        $deinterlace = isset($plugin_cookies->deinterlace) ? $plugin_cookies->deinterlace : 'bob';
        #hd_print("gmt----->$gmt");
        #$doc = null;
       
        if (intval($gmt) < 0)
        
        {
            $doc=HD::get_daten("json/live?token=".$this->cookie."&cid=".$channel_id."&protected=".$protect_code, $this->cookie);
			#hd_print("doc_live---$doc");
			$doc = json_decode($doc);
			$url = $doc->live->url;
			$url = str_ireplace("http://","http://ts://",$url);
			$url = $url . ($buf_time > 0 ? '|||dune_params|||buffering_ms:' . $buf_time : '');
			$url = $url . ",deint_mode:$deinterlace";
        }
        elseif($gmt == 'rec')
        {
            $doc=HD::get_daten("json/live?token=".$this->cookie."&cid=".$channel_id."&protected=".$protect_code, $this->cookie);
			#hd_print("doc_live---$doc");
			$doc = json_decode($doc);
			$url = $doc->live->url;
        }
        else
        {
            $doc = HD::get_daten('json/rec?token='.$this->cookie.'&cid='.$channel_id.'&time='.$gmt.'&protected='.$protect_code, $this->cookie);
			#hd_print("DOC_ARCHIVE----->$doc");
			$doc = json_decode($doc);
			$url = strval($doc->rec->url);
			$url = 'http://ts://127.0.0.1:1000/cgi-bin/arch?' . $url;
			            
        }
        #hd_print("url:--->>>$url");
        return $url;
     }

///////////////////////////////////////////////////////////////////////////
//TODO 3
	public function set_settings($control_id, $new_value)
	{
		if($control_id == 'pcode')
		{
			$doc = HD::http_get_document(self::API_URL.'set?sid='.$this->cookie.$new_value);
		}
		else if($control_id == 'timeshift')
		{
			$doc = HD::http_get_document(self::API_URL.'set?sid='.$this->cookie.$new_value);
		}
		else
		{
			$doc = self::API_URL.'settings_set.php?var='.$control_id.'&val='.$new_value;
		}
		hd_print("--->>> set_settings: $doc");
		try
		{
			$data = simplexml_load_string($doc);
		}
		catch (Exception $e)
		{
			throw $this->api_exception($e,"get settings $control_id failed.", false);
		}
		

		if (!isset($data->error))
		{	if($control_id != 'pcode')
			hd_print("sapis");
			 $this->settings->{$control_id}->value = $new_value;
		}
		else
		{
			throw new MyPlugIN_Exception($data->error->message, $code,false);
		}
	
	}
	public function get_akk_pro()
	{
	if(isset($this->cookie)) {
	$paket = HD::get_daten('json/account?token='.$this->cookie, $this->cookie);
	#hd_print("paket---------->$paket");
	$paket = json_decode($paket);
	#$paket = $paket->results->tariff_plan;
	}
	else
	$paket = 0;
	return $paket;
	}
	//////////////////////////
	public function get_settings_pro()
	{
	if(isset($this->cookie)) {
	$settings = HD::get_daten('json/settings?token='.$this->cookie, $this->cookie);
	#hd_print("settings---------->$settings");
	$settings = json_decode($settings);
	#$settings = $settings->results->tariff_plan;
	}
	else
	$settings = 0;
	return $settings;
	}
	///////////////////////////////////////
	public function set_server($control_id, $p_var)
	{
	if(isset($this->cookie)) {
	$server = HD::get_daten('json/set?token='.$this->cookie . "&server=$p_var", $this->cookie);
	#hd_print("server---------->$server");
	}
	else
	$server = 0;
	return $server;
	}
	public function set_timezone($control_id, $p_var)
	{
	if(isset($this->cookie)) {
	$timezone = HD::get_daten('json/set?token='.$this->cookie . "&timezone=$p_var", $this->cookie);
	#hd_print("timezone---------->$timezone");
	}
	else
	$timezone = 0;
	return $timezone;
	}
///////////////////////////////////////////////////////////////////////////
//TODO 4
	public function set_channels_order($id,$act)
	{
		if($id == -1)
		{
			$doc = MyPlugIN_Config::API_URL.'/set_channels_order.php?act='.$act;
		}
		else
		{
			$doc = MyPlugIN_Config::API_URL.'/set_channels_order.php?id='.$id.'&act='.$act;
		}
		hd_print("--->>> set_channels_order: $doc");
		$data = $this->json_fetch($doc,0);
		if (intval($data->message->code) == 4)
		{	
			return $data;
		}
		else
		{
			throw new MyPlugIN_Exception($data->error->message, $code);
		}

	}

///////////////////////////////////////////////////////////////////////////
	public function get_channels_order()
	{
		$doc = MyPlugIN_Config::API_URL.'/get_channels_oder.php';
		hd_print("--->>> get_channels_order: $doc");
		$data = $this->json_fetch($doc,0);
		return $data;	
	}

///////////////////////////////////////////////////////////////////////////
	public function json_fetch($url,$islogin)
	{
		if($islogin == 0)
		{
			if (strpos($url,"?") === false )
			{
		    		$url .= "?$this->cookie";
			}
			else
			{
		    		$url .= "&$this->cookie";
			}
		}
		$doc = HD::http_get_document($url);
		#hd_print("--->>> get_json: $doc");
		$data = simplexml_load_string($doc);
		hd_print("--->>> get_xml: $doc");
		if ($data === null)
                throw new Exception('Invalid data received from server');
		if (isset($data->error))
            	{
			$code = intval($data->error->code);
			hd_print("API error: URL '$url' " .
                    	"returned error with code=$code, msg=" .
                    	$data->error->message . '.');
			throw new MyPlugIN_Exception($data->error->message, $code);
		}
		return $data;
	}
	///////////////////////////////////////////////////////////////////////////
	private function do_get_edit_subscription_defs(&$plugin_cookies, $handler, $add_params)
    {
        $defs = array();

        $login = isset($plugin_cookies->login) ? $plugin_cookies->login : '';
        $pass = isset($plugin_cookies->pass) ? $plugin_cookies->pass : '';

        ControlFactory::add_text_field($defs,
            $handler, $add_params,
            'login', 'Логин на tvclub.us:',
            $login, false, false, false, false, 750);

        ControlFactory::add_text_field($defs,
            $handler, $add_params,
            'pass', 'Пароль на tvclub.us:',
            $pass, false, true, false, false, 750);

        ControlFactory::add_vgap($defs, 50);

        ControlFactory::add_button($defs,
            $handler, $add_params,
            'apply_sub', null, 'Ввести', 300);

        ControlFactory::add_vgap($defs, -3);

        ControlFactory::add_close_dialog_button($defs,
            'Отмена', 300);
			
		#ControlFactory::add_label($defs, '', '');
		ControlFactory::add_img_label($defs, '', '<text dy="7" size="small"> Нажмите </text><icon>gui_skin://special_icons/controls_button_blue.aai</icon><text dy="7" size="small"> для вызова экранной клавиатуры</text>', 0, 0, 0);
        return $defs;
    }
	/////////////////////////////////////////////////////////////////////////// 
   public function do_get_edit_subscription_action(&$plugin_cookies, $handler, $add_params = null) 
	{
        	return ActionFactory::show_dialog(
            		'Введите данные логин и пароль',
            		$this->do_get_edit_subscription_defs(
                	$plugin_cookies, $handler, $add_params),
            		true);

	} 
///////////////////////////////////////////////////////////////////////////
    public function apply_sub(&$plugin_cookies, &$user_input)
    {
        if (!isset($user_input->control_id) ||
            $user_input->control_id != 'apply_sub')
        {
	    #hd_print("dalshe: $user_input->control_id");
            return false;
	}
	if ($user_input->control_id == 'close')
        {
		hd_print("close");
		return array(
               'need_close_dialog' => true,
                'action' =>ActionFactory::close_dialog());
        }


        if ($user_input->login === '' || $user_input->pass === '')
        {
		return array(
                'need_close_dialog' => false,
                'action' =>ActionFactory::show_error(false,'Error',array('Поле Логин не может быть пустым.')));
        }

	$plugin_cookies->login = $user_input->login;
	$plugin_cookies->pass = $user_input->pass;
	$islogged = $this->is_logged_in();
	if ($islogged == true)
	{
        	$this->logout();
	}
        $post_action = null;
        try
        {
            $this->login_mylogin($plugin_cookies);
        }
        catch (DuneException $e)
        {
            $post_action = $e->get_error_action();
        }
		
	if ($this->is_logged == false)
	{
	hd_print("--------------------");
		return array(
                'need_close_dialog' => false,
                'action' =>ActionFactory::show_error(false,'Error',array('Неправильный логин или пароль')));
	}
        return array(
            'need_close_dialog' => true,
            'action' => $post_action);
    }
	///////////////////////////////////////////////////////////////////////////
	public function check_for_arch()
    {
        $plugin_dir = DuneSystem::$properties['install_dir_path'];
        if (!file_exists('/tmp/arch/msdl'))
        {
            system("mkdir /tmp/arch",$return_var);
            system("cp $plugin_dir/bin/msdl /tmp/arch/msdl",$return_var);
            system("chmod +x /tmp/arch/msdl", $return_var);
        }
        if (!file_exists('/tmp/arch/rec'))
        {
            system("mkdir /tmp/arch",$return_var);
            system("cp $plugin_dir/bin/rec /tmp/arch/rec",$return_var);
            system("chmod +x /tmp/arch/rec", $return_var);
        }
        if (!file_exists('/tmp/arch/cgi-bin/arch'))
        {
            system("mkdir /tmp/arch/cgi-bin",$return_var);
            system("cp $plugin_dir/bin/arch /tmp/arch/cgi-bin/arch",$return_var);
            system("chmod +x /tmp/arch/cgi-bin/arch", $return_var);
        }
        $hh = system('ps | grep httpd | grep -c /tmp/arch',$return_var);
        #hd_print("var httpd:  $hh");
        if ( $hh <= 1)
        {
            system("httpd -h /tmp/arch -p 1000",$return_var);
        }
        return true;
    }
	#######################
    public function get_icon($id)
    {
		#hd_print("BLIN----------------->");
        $archive = DefaultArchive::get_archive(
            TVCLUB_ARCHIVE_ID,
            TVCLUB_ARCHIVE_URL_PREFIX);

        return $archive->get_archive_url($id);
    }

    public function get_group_icon($group_id)
    {
        return $this->get_icon("group_$group_id.png");
		return;
    }

    public function get_channel_icon($channel_id)
    {
        return $this->get_icon("channel_$channel_id.png");
    }
 	public function get_radio_channel_icon($channel_id)
    {
        return $this->get_icon("radio_$channel_id.png");
    }
	public function get_icon_genre($name)
    {
        return 'plugin_file://icons/vod/' . $name;
    }
	public function get_archive()
    {
        return DefaultArchive::get_archive(
            TVCLUB_ARCHIVE_ID, TVCLUB_ARCHIVE_URL_PREFIX);
    }
}
