<?php
///////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////////////

class MyPlugIN_MainCategoryListScreen extends AbstractPreloadedRegularScreen
	implements UserInputHandler
{
    const ID = 'main_category_list';

    public static function get_media_url_str()
    {
        return MediaURL::encode(
            array
            (
                'screen_id'     => self::ID,
            ));
    }

    ///////////////////////////////////////////////////////////////////////


    private $session;
    private $tv;
    ///////////////////////////////////////////////////////////////////////

    public function __construct($session,$tv)
    {
        parent::__construct(
            self::ID, $this->get_folder_views());
	$this->session = $session;
	$this->tv = $tv;
       UserInputHandlerRegistry::get_instance()->register_handler($this);

    }
    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
	$actions = array();
        $actions[GUI_EVENT_KEY_ENTER] = ActionFactory::open_folder();
	$open_fav_action = 
                UserInputHandlerRegistry::create_action(
                    $this, 'go_fav');
        $open_fav_action['caption'] = 'Фавориты тв';
        $actions[GUI_EVENT_KEY_B_GREEN] = $open_fav_action;
	return $actions;
    }
    ///////////////////////////////////////////////////////////////////////
    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
	hd_print('main_screen: handle_user_input:');
	$this->session->check_login($plugin_cookies);
        if ($user_input->control_id === 'go_fav')
	{	$this->tv->ensure_channels_loaded($plugin_cookies);	
		return ActionFactory::open_folder(TvFavoritesScreen::get_media_url_str());		
	}
	else return null;
    }
    public function get_handler_id()
    { return self::ID; }
     public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies)
    {
	$items = array();
	
    
	
	$items[] = array
            (
                PluginRegularFolderItem::media_url => MyPlugIN_TvGroupListScreen::get_media_url_str(),
                PluginRegularFolderItem::caption => 'ТВ',
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => MyPlugIN_Config::MAIN_GROUP_ICON_PATH.'tv.png',
					ViewItemParams::icon_sel_path => MyPlugIN_Config::MAIN_GROUP_ICON_PATH.'tv_sel.png',
					ViewItemParams::item_detailed_icon_path => MyPlugIN_Config::MAIN_GROUP_ICON_PATH.'tv.png',
                )
            );
	$items[] = array
            (
                PluginRegularFolderItem::media_url => MyPlugINTvChannelListScreen::get_media_url_str(35),
                PluginRegularFolderItem::caption => 'Радио',
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => MyPlugIN_Config::MAIN_GROUP_ICON_PATH.'radio_main.png',
					ViewItemParams::icon_sel_path => MyPlugIN_Config::MAIN_GROUP_ICON_PATH.'radio_main_sel.png',
                    ViewItemParams::item_detailed_icon_path => MyPlugIN_Config::MAIN_GROUP_ICON_PATH.'radio_main.png',
                )
            );
	$items[] = array
            (
                PluginRegularFolderItem::media_url => MyPlugIN_SetupScreen::get_media_url_str(),
                PluginRegularFolderItem::caption => 'Настройки',
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => MyPlugIN_Config::MAIN_GROUP_ICON_PATH.'setup.png',
					ViewItemParams::icon_sel_path => MyPlugIN_Config::MAIN_GROUP_ICON_PATH.'setup_sel.png',
					ViewItemParams::item_detailed_icon_path => MyPlugIN_Config::MAIN_GROUP_ICON_PATH.'setup.png',
                )
            );
        return $items;
    }

    ///////////////////////////////////////////////////////////////////////
    public function get_archive(MediaURL $media_url)
    { 
        return $this->session->get_archive();
    }
    ///////////////////////////////////////////////////////////////////////
    private function get_folder_views()
    {
    	return MyPlugIN_Config::GET_MAIN_GROUP_LIST_FOLDER_VIEWS();
    }
}

///////////////////////////////////////////////////////////////////////////
?>
