<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/tv/tv_group_list_screen.php';

///////////////////////////////////////////////////////////////////////////

class MyPlugIN_TvGroupListScreen extends TvGroupListScreen implements UserInputHandler
{
    const ID = 'tv_group_list';

    ///////////////////////////////////////////////////////////////////////
    public static function get_media_url_str()
    {
        return MediaURL::encode(
            array
            (
                'screen_id' => self::ID,
            ));
    }
    ///////////////////////////////////////////////////////////////////////
	public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
		//////////////////////////////////igores////////////////////////////////////////////
		$version = VERSION_MAJOR . '.' . VERSION_MINOR . '.' . VERSION_SUBMINOR;
        $add_action = UserInputHandlerRegistry::create_action($this, 'whats_new');
        $add_action['caption'] = 'Изменения в ' . $version;
		
		$setup_view = UserInputHandlerRegistry::create_action($this, 'do_setup_menu');
        $setup_view['caption'] = 'Настройки плагина';
		
		$popup_menu_action = UserInputHandlerRegistry::create_action($this, 'popup_menu');
		//////////////////////////////////////////////////////////////////////////////
        return array
        (
            GUI_EVENT_KEY_ENTER => ActionFactory::open_folder(),
            GUI_EVENT_KEY_PLAY  => ActionFactory::tv_play(),
			GUI_EVENT_KEY_C_YELLOW => $add_action,
			GUI_EVENT_KEY_D_BLUE => $setup_view,
			GUI_EVENT_KEY_POPUP_MENU => $popup_menu_action
        );
    }
	////////////////////////////////////////////////////////////////////////
    public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies)
    {
        $this->tv->folder_entered($media_url, $plugin_cookies);

        $this->tv->ensure_channels_loaded($plugin_cookies);

        $items = array();

        foreach ($this->tv->get_groups() as $group)
        {
            $media_url = $group->is_favorite_channels() ?
                TvFavoritesScreen::get_media_url_str() :
                MyPlugINTvChannelListScreen::get_media_url_str($group->get_id());
				$test = json_decode(MyPlugINTvChannelListScreen::get_media_url_str($group->get_id()));
	    if ($test->group_id != 35) {
            $items[] = array
            (
                PluginRegularFolderItem::media_url => $media_url,
                PluginRegularFolderItem::caption => $group->get_title(),
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $group->get_icon_url(),
                    ViewItemParams::item_detailed_icon_path => $group->get_icon_url()
                )
            );
			}
        }

        $this->tv->add_special_groups($items);

        return $items;
    }
	///////////////////////////////////////////////////////////////////////
	protected function add_close_dialog_button(&$defs,
        $caption, $width)
    {
        $params = array('button_caption_centered' => 1);
        ControlFactory::add_close_dialog_button($defs,
            $caption, $width, $params);
    }
	protected function add_close_dialog_and_apply_button(&$defs,
        $name, $caption, $width)
    {
        $params = array('button_caption_centered' => 1);
        ControlFactory::add_close_dialog_and_apply_button($defs,
            $this, null,
            $name, $caption, $width, $params);
    }
	private function restore_hide_categories_defs($plugin_cookies)
    {
		$plugin_cookies->hide_category_items = '';
        $defs = array();
        ControlFactory::add_label($defs, "", "Весь список скрытых категорий будет восстановлен!!!");
		ControlFactory::add_label($defs, "", "Для применения изменений необходима перезагрузка плеера! ");
		ControlFactory::add_label($defs, "", "Перезагрузить плеер сейчас?");
		$this->add_close_dialog_and_apply_button($defs,
            'restart_restore', 'Да', 250);
        $this->add_close_dialog_button($defs,
            'Нет', 250);
        return $defs;
    }
	private function make_hide_category_defs($category_id, $title, &$plugin_cookies)
    {
		$hide_category_items = isset($plugin_cookies->hide_category_items) ? $plugin_cookies->hide_category_items : '';
		if (!ListUtil::is_in_list($hide_category_items, $category_id))
            {
            $plugin_cookies->hide_category_items = ListUtil::add_item($hide_category_items, $category_id);
			
			$defs = array();
			ControlFactory::add_label($defs, "", "Категория " . "«" . $title . "»" . " с ID " . "«" . $category_id . "»" . " будет скрыта после перезагрузки плеера!");
			ControlFactory::add_label($defs, "", "Для применения изменений необходима перезагрузка плеера! ");
			ControlFactory::add_label($defs, "", "Вы можете продолжать скрывать другие категории. ");
			ControlFactory::add_label($defs, "", "Перезагрузить плеер сейчас?");
			$this->add_close_dialog_button($defs,
				'Позже', 300);
			$this->add_close_dialog_and_apply_button($defs,
				'restart_hide', 'Сейчас', 300);
			return $defs;
			}
    }
	#############################NEW###############################################
	public function handle_user_input(&$user_input, &$plugin_cookies)
	{
		$hided_categories = isset($plugin_cookies->hided_categories) ? $plugin_cookies->hided_categories : 'no';
		$hide_category_items = isset($plugin_cookies->hide_category_items) ? $plugin_cookies->hide_category_items : '';
        #hd_print('SovoktvTvGroupListScreen: handle_user_input:');
        foreach ($user_input as $key => $value)
            #hd_print("  $key => $value");
		if ($user_input->control_id == 'popup_menu')
        {
            if (!isset($user_input->selected_media_url))
                return null;

            $media_url = MediaURL::decode($user_input->selected_media_url);
            $group_id = $media_url->group_id;
			
			#########hide#############
			$hide_category_action =
                UserInputHandlerRegistry::create_action(
                    $this, 'hide_category');
            $hide_category_caption = 'Скрыть категорию';
			
			$restore_category_action =
                UserInputHandlerRegistry::create_action(
                    $this, 'restore_categories_dialog');
            $restore_category_caption = 'Восстановить скрытые категории';
			
			#########hide##############
			$menu_items[] = array(
                GuiMenuItemDef::caption => $hide_category_caption,
                GuiMenuItemDef::action => $hide_category_action,
				GuiMenuItemDef::icon_url => 'plugin_file://icons/small/hide_channel.aai');
			if($hide_category_items <> '')
			{
			$menu_items[] = array(
                GuiMenuItemDef::caption => $restore_category_caption,
                GuiMenuItemDef::action => $restore_category_action,
				GuiMenuItemDef::icon_url => 'plugin_file://icons/small/restore_all.aai');
			##########
			}
			$menu_items [] =  array( 
				GuiMenuItemDef::is_separator => true,);	

			return ActionFactory::show_popup_menu($menu_items);
        }
		#############################################################################
		else if ($user_input->control_id == 'hide_category')
			{
				if (!isset($user_input->selected_media_url))
                return null;

            $media_url = MediaURL::decode($user_input->selected_media_url);
			$group_id = $media_url->group_id;
			$cat_title = $this->categ_id($group_id);
			#hd_print("group_id ------------=> $group_id");
			$hide_category_items = isset($plugin_cookies->hide_category_items) ? $plugin_cookies->hide_category_items : '';
			if (!ListUtil::is_in_list($hide_category_items, $group_id))
                    {
					if($group_id == '__all_channels')
					{
					return ActionFactory::show_title_dialog("НЕЛЬЗЯ СКРЫТЬ КАТЕГОРИЮ «ВСЕ КАНАЛЫ»!!!");	
					}
					elseif($group_id == '')
					{
					return ActionFactory::show_title_dialog("НЕЛЬЗЯ СКРЫТЬ «ИЗБРАННОЕ»!!!");	
					}
					$defs = $this->make_hide_category_defs($group_id, $cat_title, &$plugin_cookies);
					return  ActionFactory::show_dialog
					("Внимание!!!",
					$defs,
					true);
                    break;
			}
			}
		else if ($user_input->control_id == 'restore_categories_dialog')
			{
			$defs = $this->restore_hide_categories_defs($plugin_cookies);
					return  ActionFactory::show_dialog
					("Внимание!!!",
					$defs,
					true);
			}
		
		else if ($user_input->control_id == 'view_hide_categories_action')
			{
			$plugin_cookies->hided_categories = 'yes';
			$perform_new_action = UserInputHandlerRegistry::create_action(
                    $this, 'reset_controls');
				return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
			}
		else if ($user_input->control_id == 'hide_hide_categories_action')
			{
			$plugin_cookies->hided_categories = 'no';
			$perform_new_action = UserInputHandlerRegistry::create_action(
                    $this, 'reset_controls');
				return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
			}
		else if ($user_input->control_id == 'restore_categories')
			{
			$plugin_cookies->hide_category_items = '';
			$perform_new_action = UserInputHandlerRegistry::create_action(
                    $this, 'reset_controls');
				return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
			}
		else if ($user_input->control_id === 'restart_hide')
			{
				
				$perform_new_action = UserInputHandlerRegistry::create_action(
                    $this, 'reset_controls');
				ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
				usleep(500000);
                shell_exec('killall shell');
				#break;
			}
		else if ($user_input->control_id === 'restart_restore')
			{
				
				$perform_new_action = UserInputHandlerRegistry::create_action(
                    $this, 'reset_controls');
				ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
				usleep(500000);
                shell_exec('killall shell');
				#break;
			}
		if($user_input->control_id == 'do_setup_menu')
		{
		return ActionFactory::open_folder('setup');
		}
		if($user_input->control_id == 'whats_new')
		{
		return $this->_whats_new_dialog();
		}
		return null;
		
	}
	private function categ_id($cat) {
    $categories = array (
		intval(19) => 'Взрослые', intval(12) => 'Региональные',
        intval(20) => 'Украинские',
        intval(1) => 'Эфирные', intval(2) => 'Информация',
        intval(3) => 'Познавательные', intval(4) => 'Развлекательные',
        intval(5) => 'Детские', intval(6) => 'Кино',
        intval(7) => 'Спорт', intval(8) => 'Музыка',
        intval(9) => 'Культура', intval(11) => 'Разное',
		intval(21) => 'Немецкие', intval(22) => 'Английские',
		intval(23) => 'Израиль', intval(24) => 'Франция',
		intval(25) => 'Испания', intval(26) => 'Скандинавские',
		intval(27) => 'Польша', intval(28) => 'Индийские',
		intval(29) => 'Румынские',
        '__all_channels' => 'Все каналы'
    );
	
    foreach ($categories as $key => $value) {
        $cat = str_replace($key, $value, $cat);
    }
    return $cat;
	}
   # public function get_archive(MediaURL $media_url)
   # { 
   #     return $this->session->get_archive();
   # }
}

///////////////////////////////////////////////////////////////////////////
?>
